/************************************************************************************************************************************
 ***  This program creates the 2019-20 Private School Survey (PSS) public-use data file with permanently assigned formats.        ***
 ***                                                                                                                              ***
 ***  NOTES: You will have to change the /FILE= and SAVE OUTFILE statements below to match the names and locations of your data.  ***
 ***                                                                                                                              ***
 ***         The SPSS code below was written for SPSS v20 or above. Labels were given a maximun length of 60 characters. If you   ***
 ***         are using SPSS v11 or below, you should be aware that labels could be truncated. You may wish to abbreviate labels   ***
 ***         so that they are unique and are descriptive.                                                                         ***
 ***                                                                                                                              ***
 ***         There may be missing data for some institutions due to parent-child relations.                                       ***
 ***                                                                                                                              ***
 ***  PROGRAM: Create PU 2019-20 PSS SPSS Dataset.sps                                                                             ***
 ***  AUTHOR:  National Center for Education Statistics                                                                           ***
 ***  DATE:    November 16, 2021                                                                                                  ***
 ************************************************************************************************************************************/

PRESERVE.
SET DECIMAL DOT.

GET DATA
 /TYPE=TXT
 /FILE="C:\NCES\PSS\2019-20\Data\pss1920_pu.csv"
 /DELIMITERS=","
 /QUALIFIER='"'
 /FIRSTCASE=2
 /VARIABLES=
PFNLWT F14.10
REPW1 F14.10
REPW2 F14.10
REPW3 F14.10
REPW4 F14.10
REPW5 F14.10
REPW6 F14.10
REPW7 F14.10
REPW8 F14.10
REPW9 F14.10
REPW10 F14.10
REPW11 F14.10
REPW12 F14.10
REPW13 F14.10
REPW14 F14.10
REPW15 F14.10
REPW16 F14.10
REPW17 F14.10
REPW18 F14.10
REPW19 F14.10
REPW20 F14.10
REPW21 F14.10
REPW22 F14.10
REPW23 F14.10
REPW24 F14.10
REPW25 F14.10
REPW26 F14.10
REPW27 F14.10
REPW28 F14.10
REPW29 F14.10
REPW30 F14.10
REPW31 F14.10
REPW32 F14.10
REPW33 F14.10
REPW34 F14.10
REPW35 F14.10
REPW36 F14.10
REPW37 F14.10
REPW38 F14.10
REPW39 F14.10
REPW40 F14.10
REPW41 F14.10
REPW42 F14.10
REPW43 F14.10
REPW44 F14.10
REPW45 F14.10
REPW46 F14.10
REPW47 F14.10
REPW48 F14.10
REPW49 F14.10
REPW50 F14.10
REPW51 F14.10
REPW52 F14.10
REPW53 F14.10
REPW54 F14.10
REPW55 F14.10
REPW56 F14.10
REPW57 F14.10
REPW58 F14.10
REPW59 F14.10
REPW60 F14.10
REPW61 F14.10
REPW62 F14.10
REPW63 F14.10
REPW64 F14.10
REPW65 F14.10
REPW66 F14.10
REPW67 F14.10
REPW68 F14.10
REPW69 F14.10
REPW70 F14.10
REPW71 F14.10
REPW72 F14.10
REPW73 F14.10
REPW74 F14.10
REPW75 F14.10
REPW76 F14.10
REPW77 F14.10
REPW78 F14.10
REPW79 F14.10
REPW80 F14.10
REPW81 F14.10
REPW82 F14.10
REPW83 F14.10
REPW84 F14.10
REPW85 F14.10
REPW86 F14.10
REPW87 F14.10
REPW88 F14.10
CSOURCE F1.0
P135 F1.0
P140 F3.0
P145 F1.0
P150 F4.0
P155 F1.0
P160 F4.0
P165 F1.0
P170 F3.0
P175 F1.0
P180 F3.0
P185 F1.0
P190 F3.0
P195 F1.0
P200 F3.0
P205 F1.0
P210 F3.0
P215 F1.0
P220 F3.0
P225 F1.0
P230 F3.0
P235 F1.0
P240 F3.0
P245 F1.0
P250 F3.0
P255 F1.0
P260 F3.0
P265 F1.0
P270 F3.0
P275 F1.0
P280 F3.0
P285 F1.0
P290 F3.0
P295 F1.0
P300 F3.0
P305 F4.0
P320 F4.0
P330 F4.0
P325 F4.0
P316 F4.0
P318 F4.0
P310 F3.0
P332 F4.0
P335 F1.0
P340 F4.0
P345 F1.0
P350 F3.0
P360 F3.0
P365 F1.0
P370 F1.0
P385 F3.0
P390 F3.0
P395 F3.0
P400 F3.0
P405 F3.0
P410 F3.0
P415 F1.0
P420 F1.0
P425 F1.0
P430 F1.0
P435 F1.0
P440 F2.0
P445 F1.0
P450 F1.0
P455 F1.0
P460 F1.0
P465 F1.0
P467 F1.0
P468 F1.0
P470 F1.0
P475 F1.0
P480 F1.0
P485 F1.0
P490 F1.0
P492 F1.0
P495 F1.0
P500 F1.0
P505 F1.0
P510 F1.0
P515 F1.0
P520 F1.0
P523 F1.0
P530 F1.0
P535 F1.0
P540 F1.0
P542 F1.0
P545 F1.0
P550 F1.0
P555 F1.0
P575 F1.0
P580 F1.0
P585 F1.0
P590 F1.0
P600 F1.0
P602 F1.0
P605 F1.0
P610 F1.0
P620 F1.0
P622 F1.0
P630 F1.0
P635 F1.0
P640 F1.0
P645 F3.0
P650 F2.0
P655 F2.0
P660 F1.0
PPIN A8
PINST A50
PADDRS A50
PCITY A28
PSTABB A2
PZIP A5
PZIP4 A4
PPHONE A10
PCNTY A3
PCNTY20 A5
PCNTNM A40
PL_ADD A50
PL_CIT A28
PL_STABB A2
PL_ZIP A5
PL_ZIP4 A4
REGION F1.0
PSTANSI A2
ULOCALE20 F2.0
LATITUDE20 F14.6
LONGITUDE20 F14.6
SLDLST20 A5
SLDUST20 A5
STCD20 A4
LOGR2020 F2.0
HIGR2020 F2.0
FRAME A4
TABFLAG F1.0
TYPOLOGY F1.0
RELIG F1.0
ORIENT F2.0
DIOCESE A4
LEVEL F1.0
LEVEL2 F1.0
NUMSTUDS F4.0
SIZE F1.0
NUMTEACH F3.0
UCOMMTYP F1.0
TOTHRS F14.10
MALES F4.0
F_P135 F1.0
F_P140 F1.0
F_P145 F1.0
F_P150 F1.0
F_P155 F1.0
F_P160 F1.0
F_P165 F1.0
F_P170 F1.0
F_P175 F1.0
F_P180 F1.0
F_P185 F1.0
F_P190 F1.0
F_P195 F1.0
F_P200 F1.0
F_P205 F1.0
F_P210 F1.0
F_P215 F1.0
F_P220 F1.0
F_P225 F1.0
F_P230 F1.0
F_P235 F1.0
F_P240 F1.0
F_P245 F1.0
F_P250 F1.0
F_P255 F1.0
F_P260 F1.0
F_P265 F1.0
F_P270 F1.0
F_P275 F1.0
F_P280 F1.0
F_P285 F1.0
F_P290 F1.0
F_P295 F1.0
F_P300 F1.0
F_P305 F1.0
F_P320 F1.0
F_P330 F1.0
F_P325 F1.0
F_P316 F1.0
F_P318 F1.0
F_P310 F1.0
F_P332 F1.0
F_P335 F1.0
F_P340 F1.0
F_P345 F1.0
F_P350 F1.0
F_P360 F1.0
F_P365 F1.0
F_P370 F1.0
F_P385 F1.0
F_P390 F1.0
F_P395 F1.0
F_P400 F1.0
F_P405 F1.0
F_P410 F1.0
F_P415 F1.0
F_P420 F1.0
F_P425 F1.0
F_P430 F1.0
F_P435 F1.0
F_P440 F1.0
F_P445 F1.0
F_P450 F1.0
F_P455 F1.0
F_P460 F1.0
F_P465 F1.0
F_P467 F1.0
F_P468 F1.0
F_P470 F1.0
F_P475 F1.0
F_P480 F1.0
F_P485 F1.0
F_P490 F1.0
F_P492 F1.0
F_P495 F1.0
F_P500 F1.0
F_P505 F1.0
F_P510 F1.0
F_P515 F1.0
F_P520 F1.0
F_P523 F1.0
F_P530 F1.0
F_P535 F1.0
F_P540 F1.0
F_P542 F1.0
F_P545 F1.0
F_P550 F1.0
F_P555 F1.0
F_P575 F1.0
F_P580 F1.0
F_P585 F1.0
F_P590 F1.0
F_P600 F1.0
F_P602 F1.0
F_P605 F1.0
F_P610 F1.0
F_P620 F1.0
F_P622 F1.0
F_P630 F1.0
F_P635 F1.0
F_P640 F1.0
F_P645 F1.0
F_P650 F1.0
F_P655 F1.0
F_P660 F1.0
S_KG F4.0
P_INDIAN F3.0
P_ASIAN F3.0
P_PACIFIC F3.0
P_HISP F3.0
P_WHITE F3.0
P_BLACK F3.0
P_TR F3.0
STTCH_RT F4.0.

CACHE.
EXECUTE.
DATASET NAME PSS19_20_PU WINDOW = FRONT.

IF(DIOCESE = '') DIOCESE = '-1'.
IF SYSMIS(P435) P435 = -1.
IF SYSMIS(P440) P440 = -1.
IF SYSMIS(P445) P445 = -1.

VARIABLE LABELS
PFNLWT 'Final Weight for School'
REPW1 'Replicate Weight 1'
REPW2 'Replicate Weight 2'
REPW3 'Replicate Weight 3'
REPW4 'Replicate Weight 4'
REPW5 'Replicate Weight 5'
REPW6 'Replicate Weight 6'
REPW7 'Replicate Weight 7'
REPW8 'Replicate Weight 8'
REPW9 'Replicate Weight 9'
REPW10 'Replicate Weight 10'
REPW11 'Replicate Weight 11'
REPW12 'Replicate Weight 12'
REPW13 'Replicate Weight 13'
REPW14 'Replicate Weight 14'
REPW15 'Replicate Weight 15'
REPW16 'Replicate Weight 16'
REPW17 'Replicate Weight 17'
REPW18 'Replicate Weight 18'
REPW19 'Replicate Weight 19'
REPW20 'Replicate Weight 20'
REPW21 'Replicate Weight 21'
REPW22 'Replicate Weight 22'
REPW23 'Replicate Weight 23'
REPW24 'Replicate Weight 24'
REPW25 'Replicate Weight 25'
REPW26 'Replicate Weight 26'
REPW27 'Replicate Weight 27'
REPW28 'Replicate Weight 28'
REPW29 'Replicate Weight 29'
REPW30 'Replicate Weight 30'
REPW31 'Replicate Weight 31'
REPW32 'Replicate Weight 32'
REPW33 'Replicate Weight 33'
REPW34 'Replicate Weight 34'
REPW35 'Replicate Weight 35'
REPW36 'Replicate Weight 36'
REPW37 'Replicate Weight 37'
REPW38 'Replicate Weight 38'
REPW39 'Replicate Weight 39'
REPW40 'Replicate Weight 40'
REPW41 'Replicate Weight 41'
REPW42 'Replicate Weight 42'
REPW43 'Replicate Weight 43'
REPW44 'Replicate Weight 44'
REPW45 'Replicate Weight 45'
REPW46 'Replicate Weight 46'
REPW47 'Replicate Weight 47'
REPW48 'Replicate Weight 48'
REPW49 'Replicate Weight 49'
REPW50 'Replicate Weight 50'
REPW51 'Replicate Weight 51'
REPW52 'Replicate Weight 52'
REPW53 'Replicate Weight 53'
REPW54 'Replicate Weight 54'
REPW55 'Replicate Weight 55'
REPW56 'Replicate Weight 56'
REPW57 'Replicate Weight 57'
REPW58 'Replicate Weight 58'
REPW59 'Replicate Weight 59'
REPW60 'Replicate Weight 60'
REPW61 'Replicate Weight 61'
REPW62 'Replicate Weight 62'
REPW63 'Replicate Weight 63'
REPW64 'Replicate Weight 64'
REPW65 'Replicate Weight 65'
REPW66 'Replicate Weight 66'
REPW67 'Replicate Weight 67'
REPW68 'Replicate Weight 68'
REPW69 'Replicate Weight 69'
REPW70 'Replicate Weight 70'
REPW71 'Replicate Weight 71'
REPW72 'Replicate Weight 72'
REPW73 'Replicate Weight 73'
REPW74 'Replicate Weight 74'
REPW75 'Replicate Weight 75'
REPW76 'Replicate Weight 76'
REPW77 'Replicate Weight 77'
REPW78 'Replicate Weight 78'
REPW79 'Replicate Weight 79'
REPW80 'Replicate Weight 80'
REPW81 'Replicate Weight 81'
REPW82 'Replicate Weight 82'
REPW83 'Replicate Weight 83'
REPW84 'Replicate Weight 84'
REPW85 'Replicate Weight 85'
REPW86 'Replicate Weight 86'
REPW87 'Replicate Weight 87'
REPW88 'Replicate Weight 88'
CSOURCE 'Method of Interview'
P135 '4A Ungraded Offered'
P140 '4A Ungraded Enrollment'
P145 '4B Nursery/Prekindergarten Offered'
P150 '4B Nursery/Prekindergarten Enrollment'
P155 '4C Kindergarten Offered'
P160 '4C Kindergarten Enrollment'
P165 '4D Transitional Kindergarten Offered'
P170 '4D Transitional Kindergarten Enrollment'
P175 '4E Transitional First Grade Offered'
P180 '4E Transitional First Grade Enrollment'
P185 '4F First Grade Offered'
P190 '4F First Grade Enrollment'
P195 '4G Second Grade Offered'
P200 '4G Second Grade Enrollment'
P205 '4H Third Grade Offered'
P210 '4H Third Grade Enrollment'
P215 '4I Fourth Grade Offered'
P220 '4I Fourth Grade Enrollment'
P225 '4J Fifth Grade Offered'
P230 '4J Fifth Grade Enrollment'
P235 '4K Sixth Grade Offered'
P240 '4K Sixth Grade Enrollment'
P245 '4L Seventh Grade Offered'
P250 '4L Seventh Grade Enrollment'
P255 '4M Eighth Grade Offered'
P260 '4M Eighth Grade Enrollment'
P265 '4N Ninth Grade Offered'
P270 '4N Ninth Grade Enrollment'
P275 '4O Tenth Grade Offered'
P280 '4O Tenth Grade Enrollment'
P285 '4P Eleventh Grade Offered'
P290 '4P Eleventh Grade Enrollment'
P295 '4Q Twelfth Grade Offered'
P300 '4Q Twelfth Grade Enrollment'
P305 '5 Total Student Enrollment'
P320 '6A Hispanic or Latino Students'
P330 '6B White Students'
P325 '6C Black Students'
P316 '6D Asian Students'
P318 '6E Native Hawaiian/Pacific Islander Students'
P310 '6F American Indian/Alaska Native Students'
P332 '6G Students of Two or More Races'
P335 '7A Is School Coeducational'
P340 '7B Number of Male Students'
P345 '8A Students in 12th Grade Last Year'
P350 '8B Number of 12th Graders Last Year'
P360 '8D Percent to 4-Year College'
P365 '9A Length of School Day for Kindergarten'
P370 '9B Days Per Week for Kindergarten'
P385 '10 Full-Time Teachers'
P390 '10 More Than 3/4 Time Teachers'
P395 '10 More Than 1/2 Time Teachers'
P400 '10 More Than 1/4 Time Teachers'
P405 '10 Less Than 1/4 Time Teachers'
P410 '10 Total Number of Teachers'
P415 '11 Type of School'
P420 '12A School Supports Home Schooling'
P425 '12B School Located in Private Home'
P430 '13A Does School Have Religious Orientation'
P435 '13B School Affiliation'
P440 '13C Religious Orientation'
P445 '13C Type of Catholic School'
P450 '14 No Associations'
P455 '14 Accelerated Christian Education'
P460 '14 American Association of Christian Schools'
P465 '14 Association of Christian Schools International'
P467 '14 Association of Christian Teachers and Schools'
P468 '14 Association of Classical and Christian Schools'
P470 '14 Christian Schools International'
P475 '14 Council of Islamic Schools in North America'
P480 '14 Evangelical Lutheran Education Association'
P485 '14 Friends Council on Education'
P490 '14 General Conference of SDA Church'
P492 '14 Islamic School League of America'
P495 '14 Jesuit Secondary Education Association'
P500 '14 National Association of Episcopal Schools'
P505 '14 National Catholic Educational Association'
P510 '14 National Christian School Association'
P515 '14 National Society for Hebrew Day Schools'
P520 '14 Oral Roberts University Educational Fellowship'
P523 '14 Prizmah: Center for Jewish Day Schools'
P530 '14 Southern Baptist Association of Christian Schools'
P535 '14 Other Religious School Associations'
P540 '14 American Montessori Society'
P542 '14 Association Montessori International'
P545 '14 Other Montessori Associations'
P550 '14 Association of Military Colleges and Schools'
P555 '14 Association of Waldorf Schools of North America'
P575 '14 National Association of Private Special Education Centers'
P580 '14 Other Associations for Exceptional Children'
P585 '14 European Council for International Schools'
P590 '14 National Association for the Education of Young Children'
P600 '14 National Association of Laboratory Schools'
P602 '14 National Coalition of Girls'' Schools'
P605 '14 Other Special Emphasis Associations'
P610 '14 Alternative School Network'
P620 '14 National Association of Independent Schools'
P622 '14 State/Regional Independent School Association'
P630 '14 National Independent Private Schools Association'
P635 '14 The Association of Boarding Schools'
P640 '14 Other School Associations'
P645 '15 Days in School Year'
P650 '16 Hours in School Day for Students'
P655 '16 Minutes in School Day for Students'
P660 '17 Library or Library Media Center'
PPIN 'Permanent Identification Number'
PINST 'School Name'
PADDRS 'Mailing Address'
PCITY 'Mailing City'
PSTABB 'Mailing State Postal Code'
PZIP 'Mailing Zip Code'
PZIP4 'Mailing Zip4 Code'
PPHONE 'School phone number'
PCNTY 'ANSI County Code'
PCNTY20 'ANSI County Code + State Code'
PCNTNM 'County Name'
PL_ADD 'Location Address'
PL_CIT 'Location City'
PL_STABB 'Location State Postal Code'
PL_ZIP 'Location Zip Code'
PL_ZIP4 'Location Zip4 Code'
REGION 'Census Region'
PSTANSI 'ANSI State Code (physical location of school)'
ULOCALE20 'Urban-centric Locale Code'
LATITUDE20 'Latitude'
LONGITUDE20 'Longitude'
SLDLST20 'State Legislative District - Lower'
SLDUST20 'State Legislative District - Upper'
STCD20 '114th Congressional District'
LOGR2020 '2019-20 Lowest Grade Level Recode'
HIGR2020 '2019-20 Highest Grade Level Recode'
FRAME 'Universe frame to which  school belongs'
TABFLAG 'Tabulation Flag'
TYPOLOGY 'School Typology'
RELIG 'Affiliation'
ORIENT 'School Orientation'
DIOCESE 'Diocese or archdiocese for Catholic schools'
LEVEL 'Level of Instruction'
LEVEL2 'Level of Instruction 2'
NUMSTUDS 'Total Number of Students (K-12, UG)'
SIZE 'Size of School (K-12, UG)'
NUMTEACH 'Number of K-12 Teachers (FTE)'
UCOMMTYP 'Urban-centric Community Type'
TOTHRS 'Length of School Day in Hours'
MALES 'Number of Male Students (K-12, UG)'
F_P135 'Imputation Flag for P135'
F_P140 'Imputation Flag for P140'
F_P145 'Imputation Flag for P145'
F_P150 'Imputation Flag for P150'
F_P155 'Imputation Flag for P155'
F_P160 'Imputation Flag for P160'
F_P165 'Imputation Flag for P165'
F_P170 'Imputation Flag for P170'
F_P175 'Imputation Flag for P175'
F_P180 'Imputation Flag for P180'
F_P185 'Imputation Flag for P185'
F_P190 'Imputation Flag for P190'
F_P195 'Imputation Flag for P195'
F_P200 'Imputation Flag for P200'
F_P205 'Imputation Flag for P205'
F_P210 'Imputation Flag for P210'
F_P215 'Imputation Flag for P215'
F_P220 'Imputation Flag for P220'
F_P225 'Imputation Flag for P225'
F_P230 'Imputation Flag for P230'
F_P235 'Imputation Flag for P235'
F_P240 'Imputation Flag for P240'
F_P245 'Imputation Flag for P245'
F_P250 'Imputation Flag for P250'
F_P255 'Imputation Flag for P255'
F_P260 'Imputation Flag for P260'
F_P265 'Imputation Flag for P265'
F_P270 'Imputation Flag for P270'
F_P275 'Imputation Flag for P275'
F_P280 'Imputation Flag for P280'
F_P285 'Imputation Flag for P285'
F_P290 'Imputation Flag for P290'
F_P295 'Imputation Flag for P295'
F_P300 'Imputation Flag for P300'
F_P305 'Imputation Flag for P305'
F_P320 'Imputation Flag for P320'
F_P330 'Imputation Flag for P330'
F_P325 'Imputation Flag for P325'
F_P316 'Imputation Flag for P316'
F_P318 'Imputation Flag for P318'
F_P310 'Imputation Flag for P310'
F_P332 'Imputation Flag for P332'
F_P335 'Imputation Flag for P335'
F_P340 'Imputation Flag for P340'
F_P345 'Imputation Flag for P345'
F_P350 'Imputation Flag for P350'
F_P360 'Imputation Flag for P360'
F_P365 'Imputation Flag for P365'
F_P370 'Imputation Flag for P370'
F_P385 'Imputation Flag for P385'
F_P390 'Imputation Flag for P390'
F_P395 'Imputation Flag for P395'
F_P400 'Imputation Flag for P400'
F_P405 'Imputation Flag for P405'
F_P410 'Imputation Flag for P410'
F_P415 'Imputation Flag for P415'
F_P420 'Imputation Flag for P420'
F_P425 'Imputation Flag for P425'
F_P430 'Imputation Flag for P430'
F_P435 'Imputation Flag for P435'
F_P440 'Imputation Flag for P440'
F_P445 'Imputation Flag for P445'
F_P450 'Imputation Flag for P450'
F_P455 'Imputation Flag for P455'
F_P460 'Imputation Flag for P460'
F_P465 'Imputation Flag for P465'
F_P467 'Imputation Flag for P467'
F_P468 'Imputation Flag for P468'
F_P470 'Imputation Flag for P470'
F_P475 'Imputation Flag for P475'
F_P480 'Imputation Flag for P480'
F_P485 'Imputation Flag for P485'
F_P490 'Imputation Flag for P490'
F_P492 'Imputation Flag for P492'
F_P495 'Imputation Flag for P495'
F_P500 'Imputation Flag for P500'
F_P505 'Imputation Flag for P505'
F_P510 'Imputation Flag for P510'
F_P515 'Imputation Flag for P515'
F_P520 'Imputation Flag for P520'
F_P523 'Imputation Flag for P523'
F_P530 'Imputation Flag for P530'
F_P535 'Imputation Flag for P535'
F_P540 'Imputation Flag for P540'
F_P542 'Imputation Flag for P542'
F_P545 'Imputation Flag for P545'
F_P550 'Imputation Flag for P550'
F_P555 'Imputation Flag for P555'
F_P575 'Imputation Flag for P575'
F_P580 'Imputation Flag for P580'
F_P585 'Imputation Flag for P585'
F_P590 'Imputation Flag for P590'
F_P600 'Imputation Flag for P600'
F_P602 'Imputation Flag for P602'
F_P605 'Imputation Flag for P605'
F_P610 'Imputation Flag for P610'
F_P620 'Imputation Flag for P620'
F_P622 'Imputation Flag for P622'
F_P630 'Imputation Flag for P630'
F_P635 'Imputation Flag for P635'
F_P640 'Imputation Flag for P640'
F_P645 'Imputation Flag for P645'
F_P650 'Imputation Flag for P650'
F_P655 'Imputation Flag for P655'
F_P660 'Imputation Flag for P660'
S_KG 'Total Number of Kindergarten Students'
P_INDIAN 'Percentage of American Indian or Alaskan Native Students'
P_ASIAN 'Percentage of Asian Students'
P_PACIFIC 'Percentage of Native Hawaiian or Pacific Islander students'
P_HISP 'Percentage of Hispanic Students'
P_WHITE 'Percentage of White Students'
P_BLACK 'Percentage of Black Students'
P_TR 'Percentage of Students of Two or More Races'
STTCH_RT 'Student Teacher Ratio'.

VALUE LABELS
CSOURCE
1 'Mail'
2 'Internet'
3 'Regional Office follow-up'
4 'CATI (computer-assisted telephone interview)'/
P135
1 'Yes'
2 'No'/
P145
1 'Yes'
2 'No'/
P155
1 'Yes'
2 'No'/
P165
1 'Yes'
2 'No'/
P175
1 'Yes'
2 'No'/
P185
1 'Yes'
2 'No'/
P195
1 'Yes'
2 'No'/
P205
1 'Yes'
2 'No'/
P215
1 'Yes'
2 'No'/
P225
1 'Yes'
2 'No'/
P235
1 'Yes'
2 'No'/
P245
1 'Yes'
2 'No'/
P255
1 'Yes'
2 'No'/
P265
1 'Yes'
2 'No'/
P275
1 'Yes'
2 'No'/
P285
1 'Yes'
2 'No'/
P295
1 'Yes'
2 'No'/
P335
1 'Yes'
2 'No, it is an all-female school'
3 'No, it is an all-male school'/
P345
1 'Yes'
2 'No'/
P365
0 'N/A'
1 'Full day'
2 'Half day'
3 'Both offered'/
P415
1 'Regular elementary or secondary'
2 'Montessori'
3 'Special program emphasis'
4 'Special education'
5 'Career/technical/vocational'
6 'Alternative/other'
7 'Early childhood program/child care center'/
P420
1 'Yes'
2 'No'/
P425
1 'Yes'
2 'No'/
P430
1 'Yes'
2 'No'/
P435
1 'Yes'
2 'No'
-1 'Valid Skip'/
P440
1 'Roman Catholic'
2 'African Methodist Episcopal'
3 'Amish'
4 'Assembly of God'
5 'Baptist'
6 'Brethren'
7 'Calvinist'
8 'Christian (no specific denomination)'
9 'Church of Christ'
10 'Church of God'
11 'Church of God in Christ'
12 'Church of the Nazarene'
13 'Disciples of Christ'
14 'Episcopal'
15 'Friends'
16 'Greek Orthodox'
17 'Islamic'
18 'Jewish'
19 'Latter Day Saints'
20 'Lutheran Church - Missouri Synod'
21 'Evangelical Lutheran Church in America'
22 'Wisconsin Evangelical Lutheran Synod'
23 'Other Lutheran'
24 'Mennonite'
25 'Methodist'
26 'Pentecostal'
27 'Presbyterian'
28 'Seventh-Day Adventist'
29 'Other'
-1 'Valid Skip'/
P445
1 'Parochial'
2 'Diocesan'
3 'Private'
-1 'Valid Skip'/
P450
0 'Does belong to an organization/association'
1 'Does not belong to an organization/association'/
P455
0 'Not member'
1 'Member'/
P460
0 'Not member'
1 'Member'/
P465
0 'Not member'
1 'Member'/
P467
0 'Not member'
1 'Member'/
P468
0 'Not member'
1 'Member'/
P470
0 'Not member'
1 'Member'/
P475
0 'Not member'
1 'Member'/
P480
0 'Not member'
1 'Member'/
P485
0 'Not member'
1 'Member'/
P490
0 'Not member'
1 'Member'/
P492
0 'Not member'
1 'Member'/
P495
0 'Not member'
1 'Member'/
P500
0 'Not member'
1 'Member'/
P505
0 'Not member'
1 'Member'/
P510
0 'Not member'
1 'Member'/
P515
0 'Not member'
1 'Member'/
P520
0 'Not member'
1 'Member'/
P523
0 'Not member'
1 'Member'/
P530
0 'Not member'
1 'Member'/
P535
0 'Not member'
1 'Member'/
P540
0 'Not member'
1 'Member'/
P542
0 'Not member'
1 'Member'/
P545
0 'Not member'
1 'Member'/
P550
0 'Not member'
1 'Member'/
P555
0 'Not member'
1 'Member'/
P575
0 'Not member'
1 'Member'/
P580
0 'Not member'
1 'Member'/
P585
0 'Not member'
1 'Member'/
P590
0 'Not member'
1 'Member'/
P600
0 'Not member'
1 'Member'/
P602
0 'Not member'
1 'Member'/
P605
0 'Not member'
1 'Member'/
P610
0 'Not member'
1 'Member'/
P620
0 'Not member'
1 'Member'/
P622
0 'Not member'
1 'Member'/
P630
0 'Not member'
1 'Member'/
P635
0 'Not member'
1 'Member'/
P640
0 'Not member'
1 'Member'/
P660
1 'Yes'
2 'No'/
REGION  1 'Northeast'
2 'Midwest'
3 'South'
4 'West'/
PSTANSI
'01' 'Alabama'
'02' 'Alaska'
'04' 'Arizona'
'05' 'Arkansas'
'06' 'California'
'08' 'Colorado'
'09' 'Connecticut'
'10' 'Delaware'
'11' 'District of Columbia'
'12' 'Florida'
'13' 'Georgia'
'15' 'Hawaii'
'16' 'Idaho'
'17' 'Illinois'
'18' 'Indiana'
'19' 'Iowa'
'20' 'Kansas'
'21' 'Kentucky'
'22' 'Louisiana'
'23' 'Maine'
'24' 'Maryland'
'25' 'Massachusetts'
'26' 'Michigan'
'27' 'Minnesota'
'28' 'Mississippi'
'29' 'Missouri'
'30' 'Montana'
'31' 'Nebraska'
'32' 'Nevada'
'33' 'New Hampshire'
'34' 'New Jersey'
'35' 'New Mexico'
'36' 'New York'
'37' 'North Carolina'
'38' 'North Dakota'
'39' 'Ohio'
'40' 'Oklahoma'
'41' 'Oregon'
'42' 'Pennsylvania'
'44' 'Rhode Island'
'45' 'South Carolina'
'46' 'South Dakota'
'47' 'Tennessee'
'48' 'Texas'
'49' 'Utah'
'50' 'Vermont'
'51' 'Virginia'
'53' 'Washington'
'54' 'West Virginia'
'55' 'Wisconsin'
'56' 'Wyoming'/
ULOCALE20
11 'City, Large'
12 'City, Midsize'
13 'City, Small'
21 'Suburb, Large'
22 'Suburb, Midsize'
23 'Suburb, Small'
31 'Town, Fringe'
32 'Town, Distant'
33 'Town, Remote'
41 'Rural, Fringe'
42 'Rural, Distant'
43 'Rural, Remote'/
LOGR2020
1 'All Ungraded'
2 'Lowest grade in school is prekindergarten'
3 'Lowest grade in school is kindergarten'
4 'Lowest grade in school is transitional kindergarten'
5 'Lowest grade in school is transitional first grade'
6 'Lowest grade in school is 1st grade'
7 'Lowest grade in school is 2nd grade'
8 'Lowest grade in school is 3rd grade'
9 'Lowest grade in school is 4th grade'
10 'Lowest grade in school is 5th grade'
11 'Lowest grade in school is 6th grade'
12 'Lowest grade in school is 7th grade'
13 'Lowest grade in school is 8th grade'
14 'Lowest grade in school is 9th grade'
15 'Lowest grade in school is 10th grade'
16 'Lowest grade in school is 11th grade'
17 'Lowest grade in school is 12th grade'/
HIGR2020
1 'All Ungraded'
2 'Highest grade in school is prekindergarten'
3 'Highest grade in school is kindergarten'
4 'Highest grade in school is transitional kindergarten'
5 'Highest grade in school is transitional first grade'
6 'Highest grade in school is 1st grade'
7 'Highest grade in school is 2nd grade'
8 'Highest grade in school is 3rd grade'
9 'Highest grade in school is 4th grade'
10 'Highest grade in school is 5th grade'
11 'Highest grade in school is 6th grade'
12 'Highest grade in school is 7th grade'
13 'Highest grade in school is 8th grade'
14 'Highest grade in school is 9th grade'
15 'Highest grade in school is 10th grade'
16 'Highest grade in school is 11th grade'
17 'Highest grade in school is 12th grade'/
FRAME
'LIST' 'School is part of list frame'
'AREA' 'School is part of area frame'/
TABFLAG
1 'Schools offering ungraded or grade 1 or above'
2 'Schools offering no grade higher than KG'/
TYPOLOGY
1 'Catholic, parochial'
2 'Catholic, diocesan'
3 'Catholic, private'
4 'Other religious, conservative Christian'
5 'Other relig., affiliated w/ established denomination'
6 'Other relig., not affiliated w/ any denomination'
7 'Nonsectarian, regular school'
8 'Nonsectarian, special program'
9 'Nonsectarian, special education'/
RELIG
1 'Catholic  (P430=1 and P440=1)'
2 'Other religious  (P430=1 and P440 ne 1)'
3 'Nonsectarian  (P430=2)'/
ORIENT
1 'Roman Catholic'
2 'African Methodist Episcopal'
3 'Amish'
4 'Assembly of God'
5 'Baptist'
6 'Brethren'
7 'Calvinist'
8 'Christian (no specific denomination)'
9 'Church of Christ'
10 'Church of God'
11 'Church of God in Christ'
12 'Church of the Nazarene'
13 'Disciples of Christ'
14 'Episcopal'
15 'Friends'
16 'Greek Orthodox'
17 'Islamic'
18 'Jewish'
19 'Latter Day Saints'
20 'Lutheran Church - Missouri Synod'
21 'Evangelical Lutheran Church in America'
22 'Wisconsin Evangelical Lutheran Synod'
23 'Other Lutheran'
24 'Mennonite'
25 'Methodist'
26 'Pentecostal'
27 'Presbyterian'
28 'Seventh-Day Adventist'
29 'Other'
30 'Nonsectarian'/
DIOCESE
'0101' 'Diocese of Birmingham, AL'
'0102' 'Diocese of Mobile, AL'
'0201' 'Archdiocese of Anchorage, AK'
'0202' 'Diocese of Fairbanks, AK'
'0203' 'Diocese of Juneau, AK'
'0401' 'Diocese of Phoenix, AZ'
'0402' 'Diocese of Tucson, AZ'
'0501' 'Diocese of Little Rock, AR'
'0601' 'Archdiocese of Los Angeles, CA'
'0602' 'Archdiocese of San Francisco, CA'
'0603' 'Diocese of Fresno, CA'
'0604' 'Diocese of Monterey, CA'
'0605' 'Diocese of Oakland, CA'
'0606' 'Diocese of Orange, CA'
'0607' 'Diocese of Sacramento, CA'
'0608' 'Diocese of San Bernardino, CA'
'0609' 'Diocese of San Diego, CA'
'0610' 'Diocese of San Jose, CA'
'0611' 'Diocese of Santa Rosa, CA'
'0612' 'Diocese of Stockton, CA'
'0801' 'Archdiocese of Denver, CO'
'0802' 'Diocese of Colorado Springs, CO'
'0803' 'Diocese of Pueblo, CO'
'0901' 'Archdiocese of Hartford, CT'
'0902' 'Diocese of Bridgeport, CT'
'0903' 'Diocese of Norwich, CT'
'1001' 'Diocese of Wilmington, DE'
'1101' 'Archdiocese of Washington, DC'
'1201' 'Archdiocese of Miami, FL'
'1202' 'Diocese of Pensacola-Tallahassee, FL'
'1203' 'Diocese of Orlando, FL'
'1204' 'Diocese of Palm Beach, FL'
'1205' 'Diocese of St. Augustine, FL'
'1206' 'Diocese of St. Petersburg, FL'
'1207' 'Diocese of Venice, FL'
'1301' 'Archdiocese of Atlanta, GA'
'1302' 'Diocese of Savannah, GA'
'1501' 'Diocese of Honolulu, HI'
'1601' 'Diocese of Boise, ID'
'1701' 'Archdiocese of Chicago, IL'
'1702' 'Diocese of Belleville, IL'
'1703' 'Diocese of Joliet, IL'
'1704' 'Diocese of Peoria, IL'
'1705' 'Diocese of Rockford, IL'
'1706' 'Diocese of Springfield, IL'
'1801' 'Archdiocese of Indianapolis, IN'
'1802' 'Diocese of Evansville, IN'
'1803' 'Diocese of Ft. Wayne-South Bend, IN'
'1804' 'Diocese of Gary, IN'
'1805' 'Diocese of Lafayette, IN'
'1901' 'Archdiocese of Dubuque, IA'
'1902' 'Diocese of Davenport, IA'
'1903' 'Diocese of Des Moines, IA'
'1904' 'Diocese of Sioux City, IA'
'2001' 'Archdiocese of Kansas City, KS'
'2002' 'Diocese of Dodge City, KS'
'2003' 'Diocese of Salina, KS'
'2004' 'Diocese of Wichita, KS'
'2101' 'Archdiocese of Louisville, KY'
'2102' 'Diocese of Covington, KY'
'2103' 'Diocese of Lexington, KY'
'2104' 'Diocese of Owensboro, KY'
'2201' 'Archdiocese of New Orleans, LA'
'2202' 'Diocese of Alexandria, LA'
'2203' 'Diocese of Baton Rouge, LA'
'2204' 'Diocese of Houma-Thibodaux, LA'
'2205' 'Diocese of Lafayette, LA'
'2206' 'Diocese of Lake Charles, LA'
'2207' 'Diocese of Shreveport, LA'
'2301' 'Diocese of Portland, ME'
'2401' 'Archdiocese of Baltimore, MD'
'2501' 'Archdiocese of Boston, MA'
'2502' 'Diocese of Fall River, MA'
'2503' 'Diocese of Springfield, MA'
'2504' 'Diocese of Worcester, MA'
'2601' 'Archdiocese of Detroit, MI'
'2602' 'Diocese of Grand Rapids, MI'
'2603' 'Diocese of Gaylord, MI'
'2604' 'Diocese of Kalamazoo, MI'
'2605' 'Diocese of Lansing, MI'
'2606' 'Diocese of Marquette, MI'
'2607' 'Diocese of Saginaw, MI'
'2701' 'Archdiocese of St. Paul-Minneapolis, MN'
'2702' 'Diocese of Crookston, MN'
'2703' 'Diocese of Duluth, MN'
'2704' 'Diocese of New Ulm, MN'
'2705' 'Diocese of St. Cloud, MN'
'2706' 'Diocese of Winona, MN'
'2801' 'Diocese of Biloxi, MS'
'2802' 'Diocese of Jackson, MS'
'2901' 'Archdiocese of St. Louis, MO'
'2902' 'Diocese of Jefferson City, MO'
'2903' 'Diocese of Kansas City-St. Joseph, MO'
'2904' 'Diocese of Springfield-Cape Girardeau, MO'
'3001' 'Diocese of Great Falls-Billings, MT'
'3002' 'Diocese of Helena, MT'
'3101' 'Archdiocese of Omaha, NE'
'3102' 'Diocese of Grand Island, NE'
'3103' 'Diocese of Lincoln, NE'
'3201' 'Diocese of Las Vegas, NV'
'3202' 'Diocese of Reno, NV'
'3301' 'Diocese of Manchester, NH'
'3401' 'Archdiocese of Newark, NJ'
'3402' 'Diocese of Camden, NJ'
'3403' 'Diocese of Metuchen, NJ'
'3404' 'Diocese of Paterson, NJ'
'3405' 'Diocese of Trenton, NJ'
'3501' 'Archdiocese of Santa Fe, NM'
'3502' 'Diocese of Gallup, NM'
'3503' 'Diocese of Las Cruces, NM'
'3601' 'Archdiocese of New York, NY'
'3602' 'Diocese of Albany, NY'
'3603' 'Diocese of Brooklyn, NY'
'3604' 'Diocese of Buffalo, NY'
'3605' 'Diocese of Ogdensburg, NY'
'3606' 'Diocese of Rochester, NY'
'3607' 'Diocese of Rockville Centre, NY'
'3608' 'Diocese of Syracuse, NY'
'3701' 'Diocese of Charlotte, NC'
'3702' 'Diocese of Raleigh, NC'
'3801' 'Diocese of Bismarck, ND'
'3802' 'Diocese of Fargo, ND'
'3901' 'Archdiocese of Cincinnati, OH'
'3902' 'Diocese of Cleveland, OH'
'3903' 'Diocese of Columbus, OH'
'3904' 'Diocese of Steubenville, OH'
'3905' 'Diocese of Toledo, OH'
'3906' 'Diocese of Youngstown, OH'
'4001' 'Archdiocese of Oklahoma City, OK'
'4002' 'Diocese of Tulsa, OK'
'4101' 'Archdiocese of Portland, OR'
'4102' 'Diocese of Baker, OR'
'4201' 'Archdiocese of Philadelphia, PA'
'4202' 'Diocese of Allentown, PA'
'4203' 'Diocese of Altoona-Johnstown, PA'
'4204' 'Diocese of Erie, PA'
'4205' 'Diocese of Greensburg, PA'
'4206' 'Diocese of Harrisburg, PA'
'4207' 'Diocese of Pittsburgh, PA'
'4208' 'Diocese of Scranton, PA'
'4401' 'Diocese of Providence, RI'
'4501' 'Diocese of Charleston, SC'
'4601' 'Diocese of Rapid City, SD'
'4602' 'Diocese of Sioux Falls, SD'
'4701' 'Diocese of Knoxville, TN'
'4702' 'Diocese of Memphis, TN'
'4703' 'Diocese of Nashville, TN'
'4801' 'Archdiocese of San Antonio, TX'
'4802' 'Diocese of Amarillo, TX'
'4803' 'Diocese of Austin, TX'
'4804' 'Diocese of Beaumont, TX'
'4805' 'Diocese of Brownsville, TX'
'4806' 'Diocese of Corpus Christi, TX'
'4807' 'Diocese of Dallas, TX'
'4808' 'Diocese of El Paso, TX'
'4809' 'Diocese of Ft. Worth, TX'
'4810' 'Diocese of Galveston-Houston, TX'
'4811' 'Diocese of Lubbock, TX'
'4812' 'Diocese of San Angelo, TX'
'4813' 'Diocese of Tyler, TX'
'4814' 'Diocese of Victoria, TX'
'4815' 'Diocese of Laredo, TX'
'4901' 'Diocese of Salt Lake, UT'
'5001' 'Diocese of Burlington, VT'
'5101' 'Diocese of Arlington, VA'
'5102' 'Diocese of Richmond, VA'
'5301' 'Archdiocese of Seattle, WA'
'5302' 'Diocese of Spokane, WA'
'5303' 'Diocese of Yakima, WA'
'5401' 'Diocese of Wheeling-Charleston, WV'
'5501' 'Archdiocese of Milwaukee, WI'
'5502' 'Diocese of Green Bay, WI'
'5503' 'Diocese of La Crosse, WI'
'5504' 'Diocese of Madison, WI'
'5505' 'Diocese of Superior, WI'
'5601' 'Diocese of Cheyenne, WY'
'-1' 'Valid Skip'/
LEVEL
1 'Elementary'
2 'Secondary'
3 'Combined elementary and secondary'/
LEVEL2
1 'Elementary/Middle'
2 'Secondary/High'
3 'Combined/Other'/
SIZE
1 'Less than 50 students'
2 '50-149 students'
3 '150-299 students'
4 '300-499 students'
5 '500-749 students'
6 '750 students or more'/
UCOMMTYP
1 'City   (ULOCALE20 = 11, 12, 13)'
2 'Suburb  (ULOCALE20= 21, 22, 23)'
3 'Town  (ULOCALE20= 31, 32, 33)'
4 'Rural  (ULOCALE20 = 41, 42, 43)'/
F_P135
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P140
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P145
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P150
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P155
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P160
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P165
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P170
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P175
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P180
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P185
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P190
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P195
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P200
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P205
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P210
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P215
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P220
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P225
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P230
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P235
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P240
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P245
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P250
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P255
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P260
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P265
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P270
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P275
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P280
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P285
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P290
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P295
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P300
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P305
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P320
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P330
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P325
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P316
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P318
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P310
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P332
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P335
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P340
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P345
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P350
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P360
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P365
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P370
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P385
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P390
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P395
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P400
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P405
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P410
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P415
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P420
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P425
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P430
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P435
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P440
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P445
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P450
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P455
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P460
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P465
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P467
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P468
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P470
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P475
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P480
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P485
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P490
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P492
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P495
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P500
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P505
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P510
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P515
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P520
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P523
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P530
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P535
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P540
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P542
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P545
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P550
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P555
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P575
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P580
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P585
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P590
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P600
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P602
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P605
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P610
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P620
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P622
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P630
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P635
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P640
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P645
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P650
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P655
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'/
F_P660
0 'Not imputed (original data)'
4 'Imputed by using a donor value'
5 'Data adjusted by analyst during review'.

CACHE.
EXECUTE.

FILE LABEL '2019-20 PSS Public-Use'.
SAVE OUTFILE 'C:\NCES\PSS\2019-20\pss1920_pu.sav'/compressed.